# Changelog - WPP ADI Feed

## [2.2.6] - 2026-02-06

### 🐛 Correções de Bugs

#### Sistema de Logs
- **Corrigido warning "Undefined array key"** em `class-logger.php`
  - Método `get_log_stats()` agora trata dinamicamente níveis e ações desconhecidos
  - Previne warnings do PHP para dados inesperados no banco de logs

#### Configurações
- **Alterado valor padrão de retenção de logs** de 90 para 7 dias
  - Reduz significativamente o espaço ocupado por logs antigos
  - Mantém apenas logs da última semana por padrão
  - Usuários podem ainda configurar valor personalizado

### 🔧 Melhorias Técnicas

#### Sanitização de Configurações
- **Implementado método `sanitize_settings()`** completo
  - Validação robusta de todos os campos de configuração
  - Conversão adequada de tipos de dados (inteiros, URLs, booleanos)
  - Prevenção de dados maliciosos ou malformados

#### Interface Administrativa
- **Melhorado feedback da limpeza manual de logs**
  - Exibe contagem precisa de logs removidos
  - Mensagens mais informativas sobre o resultado da operação
  - Link alternativo para casos onde formulários falham

#### Segurança
- **Melhorada validação de limpeza manual**
  - Suporte a requisições GET e POST
  - Verificação mais robusta de nonces
  - Mensagens de erro mais claras para falhas de segurança

#### Notificação de Atualização
- **Refatoração da arquitetura de notificações**
  - Método `send_activation_deactivation_report()` agora unificado
  - Suporte a ações: 'activated', 'deactivated', 'updated'
  - Eliminação de duplicação de código
  - Método `send_update_report()` mantido como deprecated para compatibilidade
- **Correção crítica na detecção de versão durante atualizações**
  - Plugin agora lê versão diretamente do cabeçalho do arquivo com regex
  - Limpa cache do OPcache antes de ler para garantir versão atualizada
  - Usa `file_get_contents()` + regex para bypass completo de cache
  - Resolve problema persistente onde versão antiga era enviada após atualização
  - Garante que API receba a versão correta do plugin recém-instalado

### 📊 Impacto nas Métricas

**Antes:**
- Warnings do PHP em logs com dados inesperados
- Retenção excessiva de logs (90 dias)
- Sanitização básica de configurações
- Feedback limitado em operações manuais

**Depois:**
- Zero warnings relacionados a logs
- Retenção otimizada (7 dias por padrão)
- Sanitização completa e segura
- Feedback detalhado e informativo

---

## [2.2.0] - 2025-12-12

### 🛠️ Compatibilidade Gutenberg
- Corrigido: Validação de tags/categorias agora funciona para todos os papéis de usuário (não apenas administradores) no editor Gutenberg.
- Ajuste: Busca de slugs de categorias/tags via REST API pública (context=view), evitando erro 403 para editores/autores.

## [2.1.0] - 2025-12-09

### 🚀 Otimizações de Performance

#### Correções Críticas
- **Removido `sleep(1)` bloqueante** em `wpp-adi-feed.php` (linha 164)
  - Substituído por `wp_schedule_single_event()` para processamento assíncrono
  - Melhoria estimada: 1 segundo por post publicado
  
- **Removido `sleep(1)` bloqueante** em `class-post-validation.php` (linha 34)
  - Eliminado delay desnecessário em requisições AJAX
  - Melhoria na resposta do editor Gutenberg

#### Limpeza de Código
- **Removido código comentado** (linhas 107-109 em wpp-adi-feed.php)
  - `save_post` hooks comentados removidos
  - Melhor legibilidade do código

- **Removido hook duplicado** `future_to_publish` (linha 118)
  - Elimina processamento duplicado de posts agendados

- **Corrigido nome do arquivo** `languages/wpp-adi-feee.pot` → `wpp-adi-feed.pot`
  - Correção de typo (3 'e' para 2 'e')

#### Melhorias JavaScript
- **Implementado debounce (500ms)** na validação de tags
  - Evita múltiplas requisições AJAX durante digitação
  - Reduz carga no servidor

#### Validação de API Aprimorada
- **Novo método `validate_tags_schema()`** em `class-api-client.php`
  - Valida estrutura de resposta da API
  - Verifica se tags são arrays de strings válidas
  - Previne cache de dados corrompidos

- **Validação de JSON** no método `register_post()`
  - Detecta respostas JSON mal formadas
  - Log detalhado de erros JSON
  - Usa `json_last_error()` para diagnóstico

- **Validação de dados** no método `prepare_post_data()`
  - Verifica campos obrigatórios (title, permalink, domain)
  - Previne envio de posts com dados incompletos

#### Sistema de Logs
- **Limpeza automática de logs** (agendamento semanal)
  - Remove logs com mais de 90 dias (configurável)
  - Reduz tamanho do banco de dados
  - Melhora performance de consultas

- **Hook `wpp_adi_feed_cleanup_logs`** implementado
  - Executado semanalmente via WP-Cron
  - Limpo adequadamente na desativação do plugin

#### Processamento Assíncrono
- **Posts agendados para processamento** com 2 segundos de delay
  - Garante que metadados/tags sejam salvos primeiro
  - Não bloqueia interface do usuário
  - Usa sistema nativo do WordPress (wp_schedule_single_event)

### 📊 Impacto nas Métricas

**Antes:**
- Bloqueio de 2 segundos por post (2x sleep)
- Múltiplas requisições AJAX simultâneas
- Sem validação de schema API
- Logs crescendo indefinidamente

**Depois:**
- Zero bloqueio síncrono
- Requisições AJAX otimizadas com debounce
- Validação robusta de dados
- Logs gerenciados automaticamente

### 🔧 Compatibilidade
- WordPress 5.0+
- PHP 7.4+
- MySQL 5.6+

### ⚠️ Breaking Changes
Nenhuma mudança quebra compatibilidade. Todas as otimizações são internas.

---

## [2.0.9] - Anterior
- Versão anterior com problemas de performance identificados
