# 🔍 Debug do WPP ADI Feed

## Problema Identificado
O plugin não está registrando posts quando salvos e não está criando logs.

## Correções Aplicadas

### 1. ✅ Removido Agendamento (que pode falhar)
- **Antes:** Usava `wp_schedule_single_event()` com delay de 2s
- **Agora:** Executa imediatamente quando post é salvo

### 2. ✅ Adicionado Logs de Debug Completos
Agora o plugin registra em `wp-content/debug.log`:
- Quando o hook é chamado
- Status do post (publicado ou não)
- Se passou nas verificações
- Se encontrou tags válidas
- Resultado do envio para API

## Como Testar

### 1. Ativar Debug no WordPress
Edite `wp-config.php` e adicione/modifique:
```php
define('WP_DEBUG', true);
define('WP_DEBUG_LOG', true);
define('WP_DEBUG_DISPLAY', false);
```

### 2. Verificar Configurações do Plugin
Vá em: **Configurações → ADI Feed Config**

Certifique-se que:
- ✅ **Auto-registro** está ATIVADO
- ✅ **URL Base da API** está correta
- ✅ Teste a conexão (botão "Testar Conexão")

### 3. Criar/Editar um Post de Teste

1. Crie um novo post
2. Adicione uma **tag válida** (da lista da API)
3. **Publique** o post
4. Verifique o arquivo de log

### 4. Verificar Logs

#### Localização do Log:
```bash
/home/lindomar/Dev/mswi/wordpress/wptest/wp-content/debug.log
```

#### Ver últimas linhas do log:
```bash
tail -f /home/lindomar/Dev/mswi/wordpress/wptest/wp-content/debug.log
```

#### Filtrar apenas logs do plugin:
```bash
grep "WPP ADI Feed" /home/lindomar/Dev/mswi/wordpress/wptest/wp-content/debug.log | tail -20
```

### 5. Interpretar os Logs

**✅ Sucesso - Você deve ver:**
```
[09-Dec-2025 ...] WPP ADI Feed: Hook handle_after_insert_post chamado para post ID 123
[09-Dec-2025 ...] WPP ADI Feed: Processando post publicado ID 123
[09-Dec-2025 ...] WPP ADI Feed: Iniciando validação para post ID 123
[09-Dec-2025 ...] WPP ADI Feed: Post ID 123 passou na verificação de processamento
[09-Dec-2025 ...] WPP ADI Feed: Auto-registro ativo
[09-Dec-2025 ...] WPP ADI Feed: Tags válidas obtidas: 50
[09-Dec-2025 ...] WPP ADI Feed: Post ID 123 - Tags válidas encontradas: tag-exemplo
[09-Dec-2025 ...] WPP ADI Feed: Dados preparados para post ID 123: {...}
[09-Dec-2025 ...] WPP ADI Feed: Resultado do registro para post ID 123: SUCESSO
[09-Dec-2025 ...] WPP ADI Feed: Post ID 123 registrado com sucesso na API
```

**❌ Possíveis Problemas:**

**a) Hook não é chamado:**
```
# Nada aparece no log
```
→ Problema: Hook `wp_after_insert_post` não está sendo disparado

**b) Post já foi registrado:**
```
[...] WPP ADI Feed: Post ID 123 já foi registrado em 2025-12-09 10:30:00
[...] WPP ADI Feed: Post ID 123 não deve ser processado
```
→ Solução: Delete o meta `_wpp_adi_feed_registered` do post

**c) Sem tags válidas:**
```
[...] WPP ADI Feed: Post ID 123 - Tags válidas encontradas: 
[...] WPP ADI Feed: Post ID 123 não tem tags válidas - não será registrado
```
→ Solução: Adicione uma tag/categoria válida ao post

**d) Auto-registro desativado:**
```
[...] WPP ADI Feed: Auto-registro desativado
```
→ Solução: Ative em Configurações → ADI Feed Config

**e) API retorna erro:**
```
[...] WPP ADI Feed: Resultado do registro para post ID 123: FALHA
```
→ Verifique: URL da API, conectividade, dados enviados

## Forçar Re-registro de Post Existente

### Via WP-CLI:
```bash
wp post meta delete POST_ID _wpp_adi_feed_registered
wp post meta delete POST_ID _wpp_adi_feed_valid_tags
```

### Via Banco de Dados:
```sql
DELETE FROM wp_postmeta 
WHERE meta_key IN ('_wpp_adi_feed_registered', '_wpp_adi_feed_valid_tags') 
AND post_id = POST_ID;
```

### Via PHP (admin):
```php
delete_post_meta($post_id, '_wpp_adi_feed_registered');
delete_post_meta($post_id, '_wpp_adi_feed_valid_tags');
```

Depois, edite e salve o post novamente.

## Verificar Logs no Dashboard

**Configurações → ADI Feed Logs**

Você deve ver:
- Posts enviados com sucesso
- Tags válidas utilizadas
- Horário de envio
- Erros (se houver)

## Comandos Úteis

### Verificar se WP-Cron está funcionando:
```bash
wp cron event list
```

### Limpar cache de tags:
```bash
wp transient delete wpp_adi_feed_valid_tags
```

### Ver todas as meta-keys do plugin em um post:
```bash
wp post meta list POST_ID | grep wpp_adi
```

### Reativar plugin (se necessário):
```bash
wp plugin deactivate wpp-adi-feed
wp plugin activate wpp-adi-feed
```

## Checklist de Diagnóstico

- [ ] Debug ativado no wp-config.php
- [ ] Auto-registro ativado nas configurações
- [ ] API acessível (teste de conexão OK)
- [ ] Post tem tag/categoria válida
- [ ] Post nunca foi registrado antes (sem meta `_wpp_adi_feed_registered`)
- [ ] Logs aparecem em debug.log quando salva post
- [ ] Logs no dashboard (ADI Feed Logs) aparecem

## Contato

Se o problema persistir após verificar todos os itens acima, compartilhe:
1. ✅ Últimas 50 linhas do debug.log (filtradas)
2. ✅ Screenshot das configurações do plugin
3. ✅ Tags/categorias do post sendo testado
4. ✅ Resultado do teste de conexão

---

**Versão:** 2.1.0 (Debug)  
**Data:** 9 de dezembro de 2025
