# WPP ADI Feed - Plugin WordPress

**Versão:** 2.2.0
**Autor:** Lindomar | Trirvium Dev BR
**Requer:** WordPress 5.0+, PHP 7.4+

## 📋 Descrição

Plugin de integração entre WordPress e API de relatórios que valida tags/categorias de posts e registra automaticamente publicações na API externa.

## 🎯 Funcionalidades

- ✅ Validação de tags em tempo real no editor Gutenberg
- ✅ Compatível com todos os papéis de usuário (admin, editor, autor, etc.)
- ✅ Registro automático de posts publicados na API
- ✅ Sistema de cache para tags válidas
- ✅ Dashboard de logs e estatísticas
- ✅ Exportação de logs em CSV
- ✅ Script CDN para rastreamento de visualizações
- ✅ Sistema de atualização automática
- ✅ Suporte a posts agendados
- ✅ Limpeza automática de logs antigos

## 🚀 Otimizações v2.1.0

### Performance

- **Processamento assíncrono:** Posts são processados sem bloquear a interface
- **Debounce JavaScript:** Validações ocorrem 500ms após última alteração
- **Zero bloqueios:** Eliminados todos os `sleep()` que travavam execução
- **Logs gerenciados:** Limpeza automática semanal de logs antigos (90+ dias)

### Qualidade de Código

- Código comentado removido
- Hooks duplicados eliminados
- Validação robusta de dados da API
- Schema validation para respostas JSON
- Tratamento apropriado de erros

### Confiabilidade

- Validação de campos obrigatórios antes do envio
- Detecção de JSON mal formado
- Logs detalhados de erros
- Cache validado antes do uso

## 📦 Instalação

1. Faça upload da pasta `wpp-adi-feed` para `/wp-content/plugins/`
2. Ative o plugin no menu "Plugins" do WordPress
3. Configure em **Configurações → ADI Feed Config**

## ⚙️ Configuração

### Configurações da API

- **URL Base da API:** Endpoint principal da API de relatórios
- **URL do Script CDN:** Script de rastreamento de visualizações
- **Timeout:** Tempo limite para requisições (padrão: 10s)
- **Duração do Cache:** Tempo de cache das tags (padrão: 1 hora)

### Configurações de Log

- **Ativar Log de Erros:** Registra todos os erros
- **Auto-Registro:** Registra posts automaticamente quando publicados
- **Retenção de Logs:** Mantém logs por 90 dias (configurável)

## 🔧 Uso

### Editor de Posts

Ao criar/editar um post, o plugin:

1. **Carrega tags válidas** da API (com cache)
2. **Valida em tempo real** tags e categorias selecionadas
3. **Exibe status** no metabox "Relatório ADI":
   - ✅ Verde: Post será registrado
   - ⚠️ Laranja: Nenhuma tag válida encontrada
4. **Registra automaticamente** ao publicar (se configurado)

### Dashboard de Logs

Acesse em **Configurações → ADI Feed Logs**

- Visualize todos os logs com filtros
- Veja estatísticas de posts enviados
- Exporte logs em CSV
- Limpe logs antigos manualmente

## 🔌 Hooks e Filtros

### Actions

```php
// Processar post com delay
do_action('wpp_adi_process_post_delayed', $post_id);

// Limpeza automática de logs
do_action('wpp_adi_feed_cleanup_logs');
```

### Funções Globais

```php
// Obter URL base da API
$api_url = wpp_adi_feed_get_api_base_url();

// Obter URL do script CDN
$cdn_url = wpp_adi_feed_get_cdn_script_url();
```

## 📊 Estrutura de Arquivos

```
wpp-adi-feed/
├── wpp-adi-feed.php          # Arquivo principal
├── CHANGELOG.md               # Histórico de alterações
├── README.md                  # Este arquivo
├── assets/
│   ├── css/
│   │   └── admin.css         # Estilos do admin
│   └── js/
│       └── admin.js          # JavaScript otimizado (debounce)
├── includes/
│   ├── class-admin-settings.php    # Configurações admin
│   ├── class-api-client.php        # Cliente API (validação aprimorada)
│   ├── class-log-admin.php         # Interface de logs
│   ├── class-logger.php            # Sistema de logs
│   ├── class-post-validation.php   # Validação de posts
│   └── class-updater.php           # Sistema de atualizações
└── languages/
    └── wpp-adi-feed.pot       # Arquivo de tradução
```

## 🎨 JavaScript API

### Eventos Customizados

```javascript
// Tags válidas carregadas
window.wppAdiFeedValidTags // Array de tags válidas

// Validar tags manualmente
validateCurrentTags(tagIds, categoryIds);
// Busca de slugs de categorias/tags agora utiliza endpoint público (context=view)
```

### Debounce

Validações aguardam 500ms de inatividade para executar, evitando múltiplas requisições.

## 🐛 Debug

### Logs

- Todos os erros são registrados na tabela `wp_wpp_adi_feed_logs`
- Visualize em **Configurações → ADI Feed Logs**

### Erros Comuns

**Tags não carregam:**
- Verifique URL da API em Configurações
- Teste conexão com botão "Testar Conexão"
- Verifique cache: tente limpar em Configurações

**Post não registrado:**
- Verifique se auto-registro está ativo
- Confirme que post tem tag/categoria válida
- Veja logs para detalhes do erro

**Validação não funciona para editores/autores:**
- Certifique-se de estar usando a versão 2.2.0+ do plugin
- A busca de slugs de categorias/tags agora utiliza a API pública (context=view), garantindo funcionamento para todos os papéis

## 🔒 Segurança

- ✅ Verificação de nonces em AJAX
- ✅ Sanitização de dados de entrada
- ✅ Validação de schema JSON
- ✅ Escape de output HTML
- ✅ Verificação de capabilities

## 📈 Performance

### Antes vs Depois (v2.1.0)

| Métrica | Antes | Depois | Melhoria |
|---------|-------|--------|----------|
| Bloqueio por post | 2s | 0s | ⚡ 100% |
| Requisições AJAX | Múltiplas | Debounced | ⚡ ~70% |
| Crescimento DB | Ilimitado | Gerenciado | 💾 90 dias |
| Validação API | Básica | Schema completo | 🔒 +100% |

## 📝 Licença

Proprietary - Trirvium Dev BR

## 🤝 Suporte

Para suporte, entre em contato com Lindomar | Trirvium Dev BR

---

**Última atualização:** 12 de dezembro de 2025

