<?php

// Previne acesso direto ao arquivo
if (!defined('ABSPATH')) {
    exit;
}

// Configurações de cabeçalho para exibir o XML no navegador
header('Content-Type: application/xml; charset=utf-8');
// header('Content-Type: application/rss+xml; charset='.get_option('blog_charset'));
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Expires: 0');

// Parâmetros da query
$posts_per_page = 10; // Limite padrão de 10 itens por página
$paged = isset($_GET['paged']) ? max(1, intval($_GET['paged'])) : 1;
$search_term = isset($_GET['term']) ? sanitize_title($_GET['term']) : '';
$start_date = isset($_GET['start_date']) ? sanitize_text_field($_GET['start_date']) : '';
$end_date = isset($_GET['end_date']) ? sanitize_text_field($_GET['end_date']) : '';
$show_description = isset($_GET['show_description']) ? sanitize_text_field($_GET['show_description']) : '';
$show_img_thumbnail = isset($_GET['show_img_thumbnail']) ? sanitize_text_field($_GET['show_img_thumbnail']) : '';

// Configura a query
$args = [
    'posts_per_page' => $posts_per_page,
    'paged' => $paged,
    'post_status' => 'publish',
    'orderby' => 'date',
    'order' => 'DESC',
    'no_found_rows' => false, // Necessário para calcular total de páginas
];

// Adiciona a tax_query se houver um termo de busca
// Adiciona a tax_query se houver um termo de busca
if (!empty($search_term)) {
    $args['tax_query'] = [
        'relation' => 'OR', // Agora ambos os filtros são obrigatórios

        // Filtra categorias pelo termo
        [
            'taxonomy' => 'category',
            'field' => 'slug',
            'terms' => $search_term,
            'operator' => 'IN',
        ],

        // Filtra tags pelo termo
        [
            'taxonomy' => 'post_tag',
            'field' => 'slug',
            'terms' => $search_term,
            'operator' => 'IN',
        ],
    ];
}
// Se nenhuma data for informada, usar as últimas 24 horas
if (empty($start_date)) {
    $start_date = date('Y-m-d H:i:s', strtotime('-24 hours'));
} else {
    $start_date = date('Y-m-d H:i:s', strtotime($start_date));
}
// Se `end_date` não for informado, assume a data e hora atual
if (empty($end_date)) {
    $end_date = date('Y-m-d H:i:s');
} else {
    $end_date = date('Y-m-d H:i:s', strtotime($end_date));
}

// Adiciona filtro de data na query
$args['date_query'] = [
    [
        'after' => $start_date,
        'before' => $end_date,
        'inclusive' => true,
    ],
];

// Inicia o objeto SimpleXMLElement
$xml = new SimpleXMLElement('<?xml version="1.0" encoding="UTF-8"?><rss version="2.0" xmlns:content="http://purl.org/rss/1.0/modules/content/" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:atom="http://www.w3.org/2005/Atom"><channel></channel></rss>');

// Cabeçalho do RSS
$channel = $xml->channel;

$channel->title = get_bloginfo('name');
$channel->link = get_bloginfo('url');

$channel->term = $search_term;

// Consulta aos posts
$posts_query = new WP_Query($args);

// Informações de paginação
$total_posts = $posts_query->found_posts;
$total_pages = $posts_query->max_num_pages;

// Adicionar informações de paginação ao canal
$channel->addChild('currentPage', $paged);
$channel->addChild('totalPages', $total_pages);
$channel->addChild('totalPosts', $total_posts);
$channel->addChild('postsPerPage', $posts_per_page);

if ($posts_query->have_posts()) {
    while ($posts_query->have_posts()) {
        $posts_query->the_post();
        $post_id = get_the_ID();

        $item = $channel->addChild('item');
        $item->addChild('title', esc_xml(get_the_title()));
        $item->addChild('link', get_permalink());
        $item->addChild('guid', get_permalink())->addAttribute('isPermaLink', 'true');
        $item->addChild('pubDate', get_post_time('r', true));

        // Descrição
        if ($show_description) {
            $description = $item->addChild('description');
            $description->addCData(apply_filters('the_excerpt_rss', get_the_excerpt()));
        }

        // Categorias
        foreach (get_the_category($post_id) as $category) {
            $item->addChild('category', esc_xml($category->slug));
        }

        // Tags
        foreach (get_the_tags($post_id) ?: [] as $tag) {
            $item->addChild('category', esc_xml($tag->slug))->addAttribute('domain', 'post_tag');
        }

        // Métricas personalizadas
        $views = function_exists('wpp_get_views')
            ? wpp_get_views($post_id)
            : get_post_meta($post_id, '_custom_view_count', true);

        $total_time = get_post_meta($post_id, '_wpp_total_time_spent', true);
        $visit_count = get_post_meta($post_id, '_wpp_visit_count', true);
        $avg_stay = ($visit_count && $total_time)
            ? round($total_time / $visit_count, 2)
            : 0;

        $item->addChild('dc:view', (int) $views);
        $item->addChild('dc:stay', number_format($avg_stay, 2));

        // Imagem do post
        if ($show_img_thumbnail && has_post_thumbnail()) {
            $thumbnail = wp_get_attachment_image_src(get_post_thumbnail_id(), 'medium');
            $item->addChild('enclosure', null)->addAttribute('url', esc_url($thumbnail[0]))->addAttribute('length', esc_attr($thumbnail[1] ?? 0))->addAttribute('type', 'image/jpeg');
        }
    }
    wp_reset_postdata();
} else {
    status_header(404);
}

// Exibe o RSS
echo $xml->asXML();
exit;
