<?php



// Evita o acesso direto ao arquivo
if (!defined('ABSPATH')) {
    exit;
}
if (!function_exists('get_userdata')) {
    require_once ABSPATH . 'wp-load.php';
}

// Definição de constantes
// define('WPP_ADI_FEED_VERSION', '1.2.9');
define('WPP_ADI_FEED_SLUG', 'wpp-adi-feed');

define('WPP_ADI_FEED_TEMPLATE', plugin_dir_path(__FILE__) . 'legado-rss-adi-feed.php');

// // Inclui as configurações de atualização
// include_once plugin_dir_path(__FILE__).'/wpp-adi-feed-update-config.php';

// include_once plugin_dir_path(__FILE__).'/wpp-adi-feed-config.php';

// Função para redirecionar o usuário após a ativação
// function wpp_redirect_to_settings_page()
// {
//     if (get_option('wpp_redirect_on_activation', false)) {
//         delete_option('wpp_redirect_on_activation');
//         wp_safe_redirect(admin_url('options-general.php?page=wpp-adi-feed-settings'));
//         exit;
//     }
// }
// add_action('admin_init', 'wpp_redirect_to_settings_page');

// Função de ativação do plugin
// function wpp_adi_feed_on_activation()
// {
//     add_option('wpp_redirect_on_activation', true);
// }
// register_activation_hook(__FILE__, 'wpp_adi_feed_on_activation');

// Função para verificar se o plugin está ativo
// function wpp_is_plugin_installed($plugin_slug)
// {
//     include_once ABSPATH.'wp-admin/includes/plugin.php';

//     return is_plugin_active($plugin_slug);
// }

// Registrar a rota da API personalizada
function wpp_register_api_route()
{
    register_rest_route(WPP_ADI_FEED_SLUG, '/check-plugin', [
        'methods' => 'GET',
        'callback' => 'wpp_check_plugin_status',
        'permission_callback' => '__return_true',
    ]);
}
add_action('rest_api_init', 'wpp_register_api_route');

// Registrar a rota da API para obter a versão do plugin
function wpp_register_version_route()
{
    register_rest_route(WPP_ADI_FEED_SLUG, '/version', [
        'methods' => 'GET',
        'callback' => 'wpp_get_plugin_version',
        'permission_callback' => '__return_true',
    ]);
}
add_action('rest_api_init', 'wpp_register_version_route');

// Função de callback que retorna a versão do plugin
function wpp_get_plugin_version()
{
    return rest_ensure_response([
        'version' => WPP_ADI_FEED_VERSION,
        'name' => 'WPP-ADI-FEED',
    ]);
}

// Função de callback para a rota da API
function wpp_check_plugin_status()
{
    $plugin_slug = 'wordpress-popular-posts/wordpress-popular-posts.php';

    return rest_ensure_response(['status' => wpp_is_plugin_installed($plugin_slug)]);
}

// Adiciona um novo feed RSS personalizado
// function adi_feed_customizado()
// {
//     add_feed('adi-feed', 'template_adi_feed_customizado');
// }
// add_action('init', 'adi_feed_customizado');

// Template do feed personalizado
// function template_adi_feed_customizado()
// {
//     if (file_exists(WPP_ADI_FEED_TEMPLATE)) {
//         load_template(WPP_ADI_FEED_TEMPLATE);
//     } else {
//         wp_die(__('O arquivo do template rss-adi-feed.php não foi encontrado.', WPP_ADI_FEED_SLUG));
//     }
// }

// Função para registrar visualizações de posts
function wpp_register_post_view()
{
    global $post;

    if (is_single() && isset($post->ID)) {
        $post_id = intval($post->ID);

        if (function_exists('wpp_get_views')) {
            $views = wpp_get_views($post_id) ?: 0;
        } else {
            $views = get_post_meta($post_id, '_custom_view_count', true) ?: 0;
            ++$views;
            update_post_meta($post_id, '_custom_view_count', $views);
        }
    }
}
add_action('wp_head', 'wpp_register_post_view');

// Captura do tempo no lado do cliente (JavaScript Assíncrono)
function wpp_track_time_on_post()
{
    if (is_single()) {
?>
        <!-- WPP-ADI-FEED -->
        <script type="text/javascript">
            (function() {
                var startTime = window.performance.now();

                function sendTimeToServer(postId, timeSpent, nonce) {
                    fetch('<?php echo admin_url('admin-ajax.php'); ?>', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/x-www-form-urlencoded'
                            },
                            body: new URLSearchParams({
                                'action': 'wpp_save_time_spent',
                                'post_id': postId,
                                'time_spent': timeSpent,
                                'nonce': nonce
                            })
                        }).then(response => response.json())
                        .then(data => {
                            if (data.success) {
                                console.log("Tempo de permanência registrado com sucesso.");
                            }
                        }).catch(error => {
                            console.error("Erro ao registrar tempo de permanência:", error);
                        });
                }

                window.addEventListener("beforeunload", function() {
                    var endTime = window.performance.now();
                    var timeSpent = ((endTime - startTime) / 1000).toFixed(2);
                    var nonce = '<?php echo wp_create_nonce('wpp_save_time_spent_nonce'); ?>';

                    sendTimeToServer(<?php echo get_the_ID(); ?>, timeSpent, nonce);
                });
            })();
        </script>
<?php
    }
}
add_action('wp_footer', 'wpp_track_time_on_post');

// Função para salvar o tempo de permanência no post meta
function wpp_save_time_spent()
{
    if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'wpp_save_time_spent_nonce')) {
        wp_send_json_error(['message' => 'Falha de segurança!']);

        return;
    }

    if (!isset($_POST['post_id'], $_POST['time_spent']) || !is_numeric($_POST['post_id']) || !is_numeric($_POST['time_spent'])) {
        wp_send_json_error(['message' => 'Dados inválidos!']);

        return;
    }

    $post_id = intval($_POST['post_id']);
    $time_spent = floatval($_POST['time_spent']);

    if ($post_id > 0 && get_post($post_id)) {
        $total_time = get_post_meta($post_id, '_wpp_total_time_spent', true) ?: 0;
        $visit_count = get_post_meta($post_id, '_wpp_visit_count', true) ?: 0;

        $total_time += $time_spent;
        ++$visit_count;

        update_post_meta($post_id, '_wpp_total_time_spent', $total_time);
        update_post_meta($post_id, '_wpp_visit_count', $visit_count);

        // Log legado removido
    }

    wp_send_json_success();
}
add_action('wp_ajax_wpp_save_time_spent', 'wpp_save_time_spent');
add_action('wp_ajax_nopriv_wpp_save_time_spent', 'wpp_save_time_spent');

function adi_feed_version()
{
    $data = [
        'name' => 'WPP ADI FEED',
        'slug' => WPP_ADI_FEED_SLUG,
        'version' => WPP_ADI_FEED_VERSION,
        'author' => 'Lindomar Trivium Dev Br',
        'description' => 'Adiciona o número de acessos de posts no feed RSS usando postmeta (com fallback caso o WPP não esteja ativo).',
        'title' => site_url(),
    ];

    // Começa o XML
    $xml = new SimpleXMLElement('<plugin_info/>');

    // Adiciona os dados ao XML
    foreach ($data as $key => $value) {
        $xml->addChild($key, $value);
    }

    // Definir o tipo de conteúdo como XML
    header('Content-Type: application/xml');
    echo $xml->asXML();
    exit;
}

function adi_register_feed()
{
    add_feed('adi-feed-version', 'adi_feed_version');
}
add_action('init', 'adi_register_feed');

// Adiciona a URL personalizada do feed
function custom_adi_feed()
{
    add_feed('adi-feed', 'custom_adi_feed_function');
}
add_action('init', 'custom_adi_feed');

// Função que gera o feed
function custom_adi_feed_function()
{
    // Inclua o código do feed XML aqui
    include_once WPP_ADI_FEED_TEMPLATE;
}
